/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.updates.FlashBean;
import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hsc.websm.updates.UpdatePanelUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class FlashTasklet
extends HwmcaPanelTasklet
implements FirmwareUpdateConstants,
PIUpdateErrorIds {
    private static final String TRACE_MASKT = "XUPDFSTT";
    private static final String TRACE_MASKF = "XUPDFSTF";
    private static final String TRACE_MASKD = "XUPDFSTD";
    private ManagedObject[] initialTargets;
    private ManagedObject[] currentTargets;
    private boolean activateFromTSide;
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "FlashTasklet");

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> FlashTasklet.service()");
        if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] Terminate task because the main Flash panel is being disposed.");
            panelTaskletResponse.terminate();
        } else if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] Handle initial request");
            ObjectId[] objectIdArray = this.getPresentationTaskParms().getTargetIds();
            this.initialTargets = (ManagedObject[])this.getObjectsForIds(objectIdArray);
            this.currentTargets = this.initialTargets;
            FlashBean flashBean = new FlashBean();
            flashBean.setTargetOutput(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "STANDARD_TARGETING").toString());
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.updates.FirmwareRes", "FlashPanel", (PanelBean)flashBean);
        } else {
            String string = (String)panelTaskletRequest.getData("command");
            if (string.endsWith("AdvancedButton")) {
                Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] Handle the Advanced Targeting button.");
                DisplayAreaDescriptorDelegate displayAreaDescriptorDelegate = null;
                displayAreaDescriptorDelegate = new DisplayAreaDescriptorDelegate("com.ibm.hsc.websm.updates.AdvTargetingTasklet", null);
                panelTaskletResponse.openModalChild(displayAreaDescriptorDelegate);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] Handle the OK button.");
                String string2 = (String)panelTaskletRequest.getData("button");
                Trace.trace((String)TRACE_MASKF, (Object)(" [FlashTasklet.service()] The selected radio button is: '" + string2 + "'"));
                if (string2.endsWith("TsideItem")) {
                    Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] The user selected t-side flash");
                    this.activateFromTSide = true;
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] The user selected p-side flash");
                    this.activateFromTSide = false;
                }
                Trace.trace((String)TRACE_MASKT, (Object)(" [FlashTasklet.service()] Before confirm, activateFromTSide set to: " + this.activateFromTSide));
                if (this.confirmUserSelection()) {
                    this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "FLASH_SIDE_SELECTION_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PLEASE_WAIT"));
                    for (int i = 0; i < this.currentTargets.length; ++i) {
                        PIUpdatesOwner pIUpdatesOwner = UpdatePanelUtilities.getPIOwnerForManagedObject(this.currentTargets[i]);
                        PIUpdater pIUpdater = (PIUpdater)pIUpdatesOwner.getUpdaterInstance();
                        Trace.trace((String)TRACE_MASKT, (Object)(" [FlashTasklet.service()] About to call PIUpdater.setActivateFromTSide with activateFromTSide set to: " + this.activateFromTSide));
                        try {
                            pIUpdater.setActivateFromTSide(this.activateFromTSide);
                            continue;
                        }
                        catch (HException hException) {
                            Trace.trace((String)TRACE_MASKF, (String)"[FlashTasklet.service()] Caught exception on setActivateFromTSide: ", (Object)((Object)hException));
                            this.logException(hException);
                        }
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] Terminate task because work has completed.");
                    panelTaskletResponse.terminate();
                    this.destroyBusyDialog();
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)" [FlashTasklet.service()] User canceled the confirmation panel.");
                    panelTaskletResponse.noAction();
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- FlashTasklet.service()");
    }

    private boolean confirmUserSelection() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> FlashTasklet.confirmUserSelection");
        boolean bl = false;
        LocalizableText localizableText = null;
        try {
            Trace.trace((String)TRACE_MASKD, (Object)(" [FlashTasklet.service()] In confirm method, activateFromTSide set to: " + this.activateFromTSide));
            String string = this.activateFromTSide ? "UPD0002" : "UPD0003";
            localizableText = this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8002"), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", string), null, new LocalizableText[]{CommonMsgApp.OK_BUTTON, CommonMsgApp.CANCEL_BUTTON});
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKF, (Object)" [confirmUserSelection] Exception working with message box!");
        }
        Trace.trace((String)TRACE_MASKD, (Object)(" [confirmUserSelection] Button pressed on message box was '" + localizableText + "'"));
        if (null != localizableText && localizableText.toString().equals(CommonMsgApp.OK_BUTTON.toString())) {
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- FlashTasklet.confirmUserSelection, returning " + bl));
        return bl;
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> FlashTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("   processing exception: " + throwable));
        new FrameworkLog(classLogInfo, -1593, throwable).log();
        Trace.trace((String)TRACE_MASKT, (Object)"<- FlashTasklet.logException()");
    }
}

